import { jsx } from "react/jsx-runtime";
import { useShallowObjectIdentity } from "@tldraw/editor";
import { createContext, useContext, useMemo } from "react";
import {
  DefaultActionsMenu
} from "../components/ActionsMenu/DefaultActionsMenu.mjs";
import {
  DefaultContextMenu
} from "../components/ContextMenu/DefaultContextMenu.mjs";
import { CursorChatBubble } from "../components/CursorChatBubble.mjs";
import { DefaultDebugMenu } from "../components/DebugMenu/DefaultDebugMenu.mjs";
import { DefaultDebugPanel } from "../components/DefaultDebugPanel.mjs";
import { DefaultMenuPanel } from "../components/DefaultMenuPanel.mjs";
import {
  DefaultHelperButtons
} from "../components/HelperButtons/DefaultHelperButtons.mjs";
import {
  DefaultKeyboardShortcutsDialog
} from "../components/KeyboardShortcutsDialog/DefaultKeyboardShortcutsDialog.mjs";
import { DefaultMainMenu } from "../components/MainMenu/DefaultMainMenu.mjs";
import { DefaultMinimap } from "../components/Minimap/DefaultMinimap.mjs";
import { DefaultNavigationPanel } from "../components/NavigationPanel/DefaultNavigationPanel.mjs";
import { DefaultPageMenu } from "../components/PageMenu/DefaultPageMenu.mjs";
import {
  DefaultQuickActions
} from "../components/QuickActions/DefaultQuickActions.mjs";
import { DefaultSharePanel } from "../components/SharePanel/DefaultSharePanel.mjs";
import { DefaultStylePanel } from "../components/StylePanel/DefaultStylePanel.mjs";
import { DefaultToolbar } from "../components/Toolbar/DefaultToolbar.mjs";
import { DefaultTopPanel } from "../components/TopPanel/DefaultTopPanel.mjs";
import { DefaultZoomMenu } from "../components/ZoomMenu/DefaultZoomMenu.mjs";
import { useShowCollaborationUi } from "../hooks/useIsMultiplayer.mjs";
const TldrawUiComponentsContext = createContext(null);
function TldrawUiComponentsProvider({
  overrides = {},
  children
}) {
  const _overrides = useShallowObjectIdentity(overrides);
  const showCollaborationUi = useShowCollaborationUi();
  return /* @__PURE__ */ jsx(
    TldrawUiComponentsContext.Provider,
    {
      value: useMemo(
        () => ({
          ContextMenu: DefaultContextMenu,
          ActionsMenu: DefaultActionsMenu,
          HelpMenu: null,
          ZoomMenu: DefaultZoomMenu,
          MainMenu: DefaultMainMenu,
          Minimap: DefaultMinimap,
          StylePanel: DefaultStylePanel,
          PageMenu: DefaultPageMenu,
          NavigationPanel: DefaultNavigationPanel,
          Toolbar: DefaultToolbar,
          KeyboardShortcutsDialog: DefaultKeyboardShortcutsDialog,
          QuickActions: DefaultQuickActions,
          HelperButtons: DefaultHelperButtons,
          DebugPanel: DefaultDebugPanel,
          DebugMenu: DefaultDebugMenu,
          MenuPanel: DefaultMenuPanel,
          SharePanel: showCollaborationUi ? DefaultSharePanel : null,
          CursorChatBubble: showCollaborationUi ? CursorChatBubble : null,
          TopPanel: showCollaborationUi ? DefaultTopPanel : null,
          ..._overrides
        }),
        [_overrides, showCollaborationUi]
      ),
      children
    }
  );
}
function useTldrawUiComponents() {
  const components = useContext(TldrawUiComponentsContext);
  if (!components) {
    throw new Error("useTldrawUiComponents must be used within a TldrawUiComponentsProvider");
  }
  return components;
}
export {
  TldrawUiComponentsProvider,
  useTldrawUiComponents
};
//# sourceMappingURL=components.mjs.map
